# 画面設計書 6-Test Result Files

## 概要

本ドキュメントは、QUASTO（Oracle APEXアプリケーション）のTest Result Files画面（Page ID: 5）の設計書である。Test Result Files画面は、テスト実行結果XMLファイルのインポート・エクスポートを行うモーダルダイアログ画面である。

### 本画面の処理概要

Test Result Files画面は、QUASTOのテスト実行結果をXMLファイルとしてインポート・エクスポートする機能を提供する。これにより、異なる環境間でテスト結果を共有したり、テスト結果をバックアップしたりすることが可能になる。

**業務上の目的・背景**：複数の開発環境やテスト環境が存在する場合、テスト結果を環境間で共有する必要がある。また、テスト結果の履歴を外部保存してバックアップすることも重要である。本画面は、XMLファイル形式でのテスト結果のインポート・エクスポートを提供することで、環境間のデータ移行やバックアップを容易にする。

**画面へのアクセス方法**：Dashboard画面から「Test Result Files」ボタンをクリックしてモーダルダイアログとして開く。

**主要な操作・処理内容**：
1. Import Test Results: XMLファイルをアップロードしてテスト結果をインポート
2. Export Test Results: 過去のテスト実行結果をXMLファイルとしてダウンロード
3. Closeボタンでダイアログを閉じて親画面に戻る

**画面遷移**：
- 遷移元：Dashboard画面（Test Result Filesボタン）
- 遷移先：なし（モーダルダイアログのためCloseで親画面に戻る）

**権限による表示制御**：Protection Level「C」（認証必須）が設定されており、ログイン済みユーザーのみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 44 | テスト結果XML格納 | 主機能 | XMLファイルからテスト結果をインポート・エクスポート |

## 画面種別

モーダルダイアログ（ファイル操作系）

## URL/ルーティング

- Page ID: 5
- エイリアス: TEST-RESULT-FILES
- URL例: `f?p=141:5:SESSION_ID`（ダイアログとして開くことを推奨）

## 入出力項目

### Import Test Results（折りたたみリージョン）

| 項目名 | 項目ID | タイプ | 必須 | 説明 |
|--------|--------|--------|------|------|
| XML file | P5_XML_FILE | ファイルアップロード | Yes | インポートするXMLファイル |

**ファイルアップロード設定**:
- 保存先: APEX_APPLICATION_TEMP_FILES
- ストレージタイプ: SESSION
- 許可するファイル形式: .xml
- 表示スタイル: DROPZONE_BLOCK（ドラッグ&ドロップ対応）

### Export Test Results（折りたたみリージョン）

| 項目名 | 表示形式 | データソース | 説明 |
|--------|----------|-------------|------|
| Download | リンク（ダウンロードアイコン） | QA_TEST_RESULTS_P0005_V.QATR_ID | XMLファイルダウンロードリンク |
| Date Added | 日付表示 | QA_TEST_RESULTS_P0005_V.QATR_ADDED_ON | テスト結果追加日時 |
| Description | テキスト | QA_TEST_RESULTS_P0005_V.QATR_DESCRIPTION | テスト結果の説明 |

### ボタン

| ボタン名 | 項目ID | 配置位置 | アクション |
|---------|--------|----------|----------|
| Close | CLOSE | CLOSE | ダイアログを閉じる |
| Import | IMPORT | NEXT | XMLファイルをインポート |

## イベント仕様

### 1-Close Dialog

**トリガー**: CLOSEボタンクリック

**処理フロー**:
1. ダイアログを閉じる（NATIVE_DIALOG_CLOSE）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページロード | QA_TEST_RESULTS_P0005_V | SELECT | エクスポート可能なテスト結果一覧を取得 |
| Import | QA_TEST_RESULTS | INSERT | XMLファイルからテスト結果をインポート |
| Export | QA_TEST_RESULTS | SELECT | 選択したテスト結果をXMLファイルとしてダウンロード |

### プロセス別詳細

#### Import file（IMPORTボタン押下時）

**PL/SQLコード**:
```sql
qa_apex_app_pkg.p_upload_unit_test_xml(pi_file_name => :P5_XML_FILE);
```

**処理フロー**:
1. APEX_APPLICATION_TEMP_FILESからアップロードファイルを取得
2. MIMEタイプが「application/xml」であることを確認
3. CLOBに変換してqa_unit_tests_pkg.f_import_test_resultを呼び出し
4. QA_TEST_RESULTSテーブルにINSERT

#### Export（Downloadリンククリック時）

**Application Process**: getTestResultXMLAttachment

**処理フロー**:
1. AI_QATR_IDパラメータからテスト結果IDを取得
2. qa_apex_app_pkg.p_download_unit_test_xmlを呼び出し
3. HTTPヘッダーを設定してXMLファイルをダウンロード

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| - | 成功 | インポート成功時 | File imported. |
| - | 情報 | エクスポート可能なファイルなし | No data found. |
| - | エラー | 無効なMIMEタイプ | Invalid MIME type of xml file: {ファイル名} - MIME type: {MIMEタイプ} |

## 例外処理

| 例外状態 | 表示・動作 |
|---------|----------|
| 無効なMIMEタイプ | 「Invalid MIME type of xml file」エラーを表示 |
| ファイルアップロードエラー | qa_logger_pkgでエラーログを記録し、例外を再スロー |
| エクスポートエラー | qa_logger_pkgでエラーログを記録し、例外を再スロー |

## 備考

- 本画面はモーダルダイアログとして表示され、親画面（Dashboard）の上に重ねて表示される
- Import/Exportリージョンは折りたたみ式（Collapsible）で、デフォルトは折りたたみ状態
- XMLファイルはutPLSQL JUnit形式でエクスポート・インポートされる
- ダウンロードファイル名は「export_unit_test_results_{日時}.xml」形式
- AutocompleteはセキュリティのためOFFに設定
- ファイルアップロードはセッション単位で管理（AUTO_DROP）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 画面定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page_00005.sql | `src/apex/f141/application/pages/page_00005.sql` | モーダルダイアログとファイルアップロード/レポートの構成 |

**主要処理フロー**:
1. **行14-24**: `wwv_flow_imp_page.create_page`でモーダルダイアログ設定
2. **行25-45**: Import Test Resultsリージョン（折りたたみ）の定義
3. **行46-90**: Export Test Resultsリージョン（インタラクティブ・レポート）の定義
4. **行91-115**: Buttons Containerリージョンの定義
5. **行116-145**: ボタン定義（CLOSE、IMPORT）
6. **行146-175**: P5_XML_FILEファイルアップロード項目の定義
7. **行176-200**: Dynamic Action（Close Dialog）の定義
8. **行201-220**: Import fileプロセスの定義

#### Step 2: PL/SQLパッケージを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | p_upload_unit_test_xml、p_download_unit_test_xmlの実装 |
| 2-2 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | f_import_test_result、f_export_test_resultの実装 |

**主要処理フロー**:
- **qa_apex_app_pkg.sql 行209-246**: `p_upload_unit_test_xml`でXMLファイルをインポート
- **qa_apex_app_pkg.sql 行248-295**: `p_download_unit_test_xml`でXMLファイルをダウンロード
- **qa_unit_tests_pkg.sql 行1435-1458**: `f_import_test_result`でQA_TEST_RESULTSにINSERT
- **qa_unit_tests_pkg.sql 行1460-1486**: `f_export_test_result`でXMLを取得

### プログラム呼び出し階層図

```
Test Result Files Page (Page 5)
    |
    +-- [Button: IMPORT - Submit]
    |       |
    |       +-- Process: Import file
    |               |
    |               +-- qa_apex_app_pkg.p_upload_unit_test_xml
    |                       |
    |                       +-- APEX_APPLICATION_TEMP_FILES (SELECT)
    |                       |
    |                       +-- MIME Type Validation
    |                       |
    |                       +-- qa_unit_tests_pkg.f_import_test_result
    |                               |
    |                               +-- INSERT INTO QA_TEST_RESULTS
    |
    +-- [Link: Download - Application Process]
    |       |
    |       +-- getTestResultXMLAttachment
    |               |
    |               +-- qa_apex_app_pkg.p_download_unit_test_xml
    |                       |
    |                       +-- qa_unit_tests_pkg.f_export_test_result
    |                               |
    |                               +-- SELECT FROM QA_TEST_RESULTS
    |                       |
    |                       +-- HTTP Header設定
    |                       |
    |                       +-- HTP.prn (XMLコンテンツ出力)
    |
    +-- [Button: CLOSE]
            |
            +-- Dynamic Action: Close Dialog
```

### データフロー図

```
[インポート]

XMLファイル             qa_apex_app_pkg              QA_TEST_RESULTS
(APEX_APPLICATION_  ───> .p_upload_unit_test_xml  ───> (INSERT)
TEMP_FILES)                    |
                               v
                        qa_unit_tests_pkg
                        .f_import_test_result

[エクスポート]

QA_TEST_RESULTS         qa_apex_app_pkg              XMLファイル
(SELECT)           <──── .p_download_unit_test_xml <──── ダウンロード
                               |
                               v
                        qa_unit_tests_pkg
                        .f_export_test_result
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00005.sql | `src/apex/f141/application/pages/page_00005.sql` | ソース | Test Result Files画面定義 |
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | XMLインポート・エクスポート処理 |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | テスト結果データベース操作 |
| page_00001.sql | `src/apex/f141/application/pages/page_00001.sql` | ソース | Dashboard画面（呼び出し元） |
